-- Messaging for Buzz Applicant Appointment - Parent Event (vettori Sprint)

SET @systemmsgeventId=(SELECT MAX(id) FROM system_msg_event);
SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='APPOINTMENT');
INSERT INTO `system_msg_event` 
(`id`, `msgConfigLevelId`, `msgSubCategoryId`, `code`, `displayCode`, `eventType`, `whetherRepetationApplicable`, `whetherInitiationRuleApplicable`, `whetherScheduledEvent`, `whetherMsgScopeApplicable`, `whetherImplicitDistributionList`, `whetherDistributionRuleApplicable`, `whetherCommonMsgTemplate`, `description`,`uiDisplayCode`) 
VALUES (@systemmsgeventId+1, '1', @msgSubCategoryId, 'BUZZ_ENQUIRY_APPOINTMENT', 'Buzz Enquiry Appointment', 'SYSTEM', 0, 0, 0, 0, 1, 0, 0, 'Buzz Enquiry Appointment','Buzz Enquiry Appointment');


SET @sysmsgevtdefaultconfId=(SELECT MAX(id) FROM sys_msg_evt_default_conf);
INSERT INTO `sys_msg_evt_default_conf` (`id`, `systemMsgEventId`, `msgTemplateConfigId`, `initiationRuleProviderId`, `sendingPriority`) 
VALUES (@sysmsgevtdefaultconfId+1, @systemmsgeventId+1, NULL, NULL, 'IMMEDIATE');


SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONTEXT_RECORD_ID');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);


SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EVENT_TRIGGER_DATE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='ACADEMY_LOCATION_IDS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EXTRA_PARAMS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

-- Template data provider for the Appointment

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'BUZZ_ENQUIRY_APPOINTMENT_DL', 'SQL');

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'BUZZ_ENQUIRY_APPOINTMENT_RECIPIENT', 'SQL');

SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='BUZZ_ENQUIRY_APPOINTMENT_RECIPIENT');
INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'BUZZ_ENQUIRY_APPOINTMENT_RECIPIENT');


SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='BUZZ_ENQUIRY_APPOINTMENT_DL');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='BUZZ_ENQUIRY_APPOINTMENT_RECIPIENT');
INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`) 
VALUES (@sysmsgevtrcptdefaultconfId+1, @sysmsgevtdefaultconfId+1, @dtproviderId, NULL, @recipientTypeId);



-- Setting the query for the Applicant distribution list

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='BUZZ_ENQUIRY_APPOINTMENT_DL');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId, "SELECT 
    T1.id AS USER_ID
FROM
    sg_appointment T1
WHERE
    T1.id IN (namedParams)",NULL);


-- Setting the query for the User Recipient

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='BUZZ_ENQUIRY_APPOINTMENT_RECIPIENT');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,
"SELECT 
    sg.id AS ID,
    T1.code AS ENQUIRY_ID,
    T1.firstName AS FIRST_NAME,
    T1.lastName AS LAST_NAME,
    T1.printName AS ENQUIRY_NAME,
    T1.primaryeEmailId AS EMAIL_ID,
    T1.phoneCountryCode AS MOBILE_CODE,
    T1.phoneNo AS MOBILE_NO,
	DATE_FORMAT(T1.enquiryDate, '%d-%m-%Y') AS ENQUIRY_DATE,
    T9.programName AS PROGRAM_NAME,
      T10.batchName AS BATCH_PRINT_NAME,
    T11.seatName AS SEAT_TYPE,
    DATE_FORMAT(sg.visitTime, '%h:%i %p') AS VISIT_TIME,
    DATE_FORMAT(sg.appointmentDate, '%d-%m-%Y') AS APPOINTMENT_DATE,
	T12.academyName AS ACADEMY_NAME,
    T12.locationName AS LOCATION_NAME,
    T12.displayName AS ACADEMY_NAME_LOCATION,
    T12.id AS ACADEMY_LOCATION_ID,
    T12.academyId AS ACADEMY_ID,
    concat(T15.phoneCountryCode, '-',T15.phoneAreaCode,'-', T15.phoneNo) AS ACADEMY_LOCATION_PHONE_NO,
	T15.primaryeEmailId AS ACADEMY_LOCATION_EMAIL_ID,
	T15.websiteURL AS ACADEMY_LOCATION_URL,
    (CASE
        WHEN
            T12.headerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T12.headerUrl)
        ELSE NULL
    END) AS HEADER_URL,
    (CASE
        WHEN
            T12.footerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T12.footerUrl)
        ELSE NULL
    END) AS FOOTER_URL,
	(CASE
        WHEN
            T12.logoUrl IS NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl,
                    '/',
                    'emailer/images/logo_default_image.png')
        WHEN
            T12.logoUrl IS NULL
                AND org.orgUrl IS NULL
        THEN
            'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
        ELSE CONCAT(org.orgUrl, '/', T12.logoUrl)
    END) AS LOGO_URL
FROM
    sg_appointment sg 
     left join
    `enquiry` T1 on T1.id = sg.enquiryid
     LEFT JOIN
    enq_student_details enq ON enq.enquiryId = T1.id
        LEFT JOIN
    admission_enq_details T2 ON T2.enqStudentDetailsId = enq.id
    left join
    prog_batch_seat_config T8 on T8.id=T2.progBatchSeatConfigId
    left join
    programs T9 on T9.id=T2.programId
    left join
    batches T10 on T10.id=T2.batchId
     left join
    seat_types T11 on T11.id=T8.seatTypeId
    left join
    academy_location T12 on T12.id=T2.academyLocationId
     left join
    academy_location_addresses T14 on T14.academyLocationId=T12.id
     inner join
    address T15 on T15.id=T14.addressId and T15.addressTypeId=10
    
       LEFT OUTER JOIN
    organizations org ON org.id = (SELECT 
            MAX(id)
        FROM
            organizations)
WHERE
    sg.id IN (namedParams) ",'{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "code",
            "resultKey": "ENQUIRY_ID",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 2
        },
        {
            "id": 4,
            "value": "displayName",
            "resultKey": "ACADEMY_NAME_LOCATION",
            "displayCode": "",
            "displayOrder": 3
        },
        {
            "id": 5,
            "value": "primaryeEmailId",
            "resultKey": "ACADEMY_LOCATION_EMAIL_ID",
            "displayCode": "",
            "displayOrder": 4
        },
        {
            "id": 6,
            "value": "academyName",
            "resultKey": "ACADEMY_NAME",
            "displayCode": "",
            "displayOrder": 5
        },
        {
            "id": 7,
            "value": "locationName",
            "resultKey": "LOCATION_NAME",
            "displayCode": "",
            "displayOrder": 6
        },
        {
            "id": 8,
            "value": "programName",
            "resultKey": "PROGRAM_NAME",
            "displayCode": "",
            "displayOrder": 7
        },
        {
            "id": 9,
            "value": "batchPrintName",
            "resultKey": "BATCH_PRINT_NAME",
            "displayCode": "",
            "displayOrder": 8
        },
        {
            "id": 10,
            "value": "seatType",
            "resultKey": "SEAT_TYPE",
            "displayCode": "",
            "displayOrder": 9
        },
        {
            "id": 11,
            "value": "enquiryDate",
            "resultKey": "ENQUIRY_DATE",
            "displayCode": "",
            "displayOrder": 10
        },
        {
            "id": 12,
            "value": "logoURL",
            "resultKey": "LOGO_URL",
            "displayCode": "",
            "displayOrder": 11
        },
        {
            "id": 13,
            "value": "headerUrl",
            "resultKey": "HEADER_URL",
            "displayCode": "",
            "displayOrder": 12
        },
        {
            "id": 14,
            "value": "footerUrl",
            "resultKey": "FOOTER_URL",
            "displayCode": "",
            "displayOrder": 13
        },
        {
            "id": 15,
            "value": "academyLocationId",
            "resultKey": "ACADEMY_LOCATION_ID",
            "displayCode": "",
            "displayOrder": 14
        },
        {
            "id": 16,
            "value": "academyId",
            "resultKey": "ACADEMY_ID",
            "displayCode": "",
            "displayOrder": 15
        },
        {
            "id": 17,
            "value": "appointmentDate",
            "resultKey": "APPOINTMENT_DATE",
            "displayCode": "",
            "displayOrder": 16
        },
        {
            "id": 18,
            "value": "visitTime",
            "resultKey": "VISIT_TIME",
            "displayCode": "",
            "displayOrder": 17
        },
        {
            "id": 19,
            "value": "printName",
            "resultKey": "ENQUIRY_NAME",
            "displayCode": "",
            "displayOrder": 18
        },
 {
            "id": 20,
            "value": "phoneNo",
            "resultKey": "ACADEMY_LOCATION_PHONE_NO",
            "displayCode": "",
            "displayOrder": 19
        },
         {
            "id": 21,
            "value": "websiteURL",
            "resultKey": "ACADEMY_LOCATION_URL",
            "displayCode": "",
            "displayOrder": 20
        }
    ]
}');


SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='BUZZ_ENQUIRY_APPOINTMENT');

SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='APPOINTMENT');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='BUZZ_ENQUIRY_APPOINTMENT_RECIPIENT');
SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='Notifications');


INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`) 
VALUES(@msgtemplateconfigId+1,'Buzz Appointment - Enquiry',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,@msgMessageTypeId,NULL,NULL,'Buzz Appointment - Enquiry',NULL,'',NULL,'','APPROVED','','1','System Admin','1');


INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'1','APPOINTMENT SCHEDULED $recipientData["ENQUIRY_ID"]','<html>
<head>
    <title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
    <tbody>
        <tr style="background-color:#f0f0f0; height:120px;">
            <td align="center" style="margin:0px;"><img height="120" src="$recipientData[&quot;HEADER_URL&quot;]" width="100%" /></td>
        </tr>
        <tr style="background-color:#f0f0f0; line-height:20px;">
            <td style="padding:20px 20px 20px 20px;">

            <p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Dear <strong>$recipientData[&quot;FIRST_NAME&quot;] $recipientData[&quot;LAST_NAME&quot;]</strong></span></span></p>

            <p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Thank you for making an appointment with us, which has been scheduled for <strong>$recipientData[&quot;APPOINTMENT_DATE&quot;]</strong> at <strong>$recipientData[&quot;VISIT_TIME&quot;]</strong></p>
            
             <p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Please be advised that should you wish to apply, we will require an original certified copy of your ID document and your latest school results and /or academic transcripts.</p>
             
             <p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">If you have any questions, please contact us on <strong>$recipientData[&quot;ACADEMY_LOCATION_PHONE_NO&quot;]</strong> or <strong>$recipientData[&quot;ACADEMY_LOCATION_EMAIL_ID&quot;]</strong>, alternatively visit our website <strong>$recipientData[&quot;ACADEMY_LOCATION_URL&quot;]</strong>.</p>
<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">
We look forward to seeing you!</p>

            <p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;"><br/>
Kind regards, <br/><br/>
<strong>$recipientData[&quot;ACADEMY_NAME_LOCATION&quot;]</strong><br/>
$recipientData[&quot;ACADEMY_LOCATION_EMAIL_ID&quot;]<br/>
$recipientData[&quot;ACADEMY_LOCATION_PHONE_NO&quot;]<br/>
$recipientData[&quot;ACADEMY_LOCATION_URL&quot;]</span></span></p>
            </td>
        </tr>
        <tr>
            <td align="center" style="margin:0px; padding:0px;"><img height="80" width="100%" src="$recipientData[&quot;FOOTER_URL&quot;]" /></td>
        </tr>
    </tbody>
</table>
</body>
</html>');


INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES(@msgtemplateId+3,@msgtemplateconfigId+1,'2',NULL,'Dear $recipientData["FIRST_NAME"] $recipientData["LAST_NAME"]

Thank you for making an appointment with us, which has been scheduled for $recipientData["APPOINTMENT_DATE"] at $recipientData["VISIT_TIME"]

Please be advised that should you wish to apply, we will require an original certified copy of your ID document and your latest school results and /or academic transcripts.


Kind regards,

$recipientData["ACADEMY_NAME_LOCATION"]
$recipientData["ACADEMY_LOCATION_EMAIL_ID"]
$recipientData["ACADEMY_LOCATION_PHONE_NO"]
$recipientData["ACADEMY_LOCATION_URL"]');


set sql_safe_updates=0;
update msg_template_config set templatelanguageValue= 'English' where templatelanguageValue is null;
update msg_template_config set whetherEnabled=1 where whetherEnabled is null;
set sql_safe_updates=1;

-- End Messaging for Buzz Applicant Appointment - Parent Event 
